function []=dftest_POW(skt,update_rate,spawn)
%ftest_POW.m
% Version 2
% Ian Stothers 3 APR 2023
% Updated 14-June 2023  - only 1 call to sktopen
% Updated 27-July 2023 - exit cleanup and simpler loop and DoTheDFT handling

if(exist('skt')==0)
   skt.ip='192.168.1.4';
   ip=skt.ip;
else
  if (ischar(skt))
   ip=skt;
  else
   ip=skt.ip;
  endif
endif

if(exist('update_rate')==0)   update_rate=20; endif

if(exist('spawn')==0)
%function []=dftest_POW(skt,update_rate,spawn)
  callstr1= ["dftest_POW("...
  sprintf("\'%s\',",ip)...
  sprintf("%f,",update_rate)...
  sprintf("%d);",1)...
  ];
  octave_spawn(callstr1);
  return
else
  if (ischar(skt))
    skt=sktopen(skt);
  endif
endif


STM32F103_bitfields; % Get some bitfields

setenv('XDG_SESSION_TYPE','x11');
dodft=udpget(skt,'DoTheDFT');
if (dodft<1)
  SRate=STM32F103_ADC_SETUP(skt,[1;0],6750000/8); % make 1st channel volts 2nd current
  STM32F103_CC_SETUP_B3(skt);
  if (size(findname(skt.name,"ADC_SR"))>0)
   udpset(skt,'ADC_SR',SRate);
  endif
  udpset(skt,'DoTheDFT',1);
endif


udp_bit_set(skt,"TIM3_CR1",CEN);

plotlen=1001;

tstep=1/update_rate;
Taxis=tstep*(0:(plotlen-1));


f1=figure;
subplot(2,1,1);
set(f1,'name',['dftest_POW.m - ' skt.ip]);

filtres=[1 i]*udpget(skt,'MeanRes');
P=filtres(3);
rfm=ones(1,plotlen)*real(P);
rfa=ones(1,plotlen)*imag(P);
pfm=  plot(Taxis,rfm');

grid on
ylabel('Real Watts');

pstrf=[ ['Filtered Power   ' skt.ip]
sprintf('Real Watts = %5.3f  Imag Watts = %5.3f',real(filtres(3)),imag(filtres(3)));
];
ptf=title(pstrf);
subplot(2,1,2);


pfa=  plot(Taxis,rfa');
grid on
ylabel('Imag Watts');
xlabel('Seconds');



tic;
tp=toc;

subplot(2,1,1);
try
 while (1)
  filtres=[1 i]*udpget(skt,'MeanRes');
  R=filtres(3);
  rfm=[ real(R)' rfm(1:(plotlen-1))];
  rfa=[ imag(R)' rfa(1:(plotlen-1))];
  set(pfm,'ydata',rfm');
  set(pfa,'ydata',rfa');

  pstrf=[ ['Filtered Power   ' skt.ip]
  sprintf('Real Watts = %5.3f  Imag Watts = %5.3f',real(filtres(3)),imag(filtres(3)));
  ];

  set(ptf,'string',pstrf);
  tp=tp+tstep;
  while (toc<tp) pause(0.01); end
 end
catch
   %cleanup
   if(isfigure(f1)==1) delete(f1); end
   return;
end_try_catch


endfunction
